var __extends = this.__extends || function (d, b) {
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var MemoryAnalyzer;
(function (MemoryAnalyzer) {
    var TreeInfo = (function () {
        function TreeInfo(gridData, expandStates, toggleFunction) {
            this.gridData = gridData;
            this.expandStates = expandStates;
            this.toggleFunction = toggleFunction;
        }
        return TreeInfo;
    })();
    MemoryAnalyzer.TreeInfo = TreeInfo;    
    var ColumnInfo = (function () {
        function ColumnInfo(index, text, tooltip, width, canSortBy, getColumnValue, getCellCSSClass, comparer, variableWidth) {
            this.index = index;
            this.text = text;
            this.tooltip = tooltip;
            this.width = width;
            this.canSortBy = canSortBy;
            this.getColumnValue = getColumnValue;
            this.getCellCSSClass = getCellCSSClass;
            this.comparer = comparer;
            this.variableWidth = variableWidth;
        }
        return ColumnInfo;
    })();
    MemoryAnalyzer.ColumnInfo = ColumnInfo;    
    var SortOrderInfo = (function () {
        function SortOrderInfo(index, order) {
            this.index = index;
            this.order = order;
        }
        return SortOrderInfo;
    })();
    MemoryAnalyzer.SortOrderInfo = SortOrderInfo;    
    var GridOptions = (function () {
        function GridOptions(height, sharedMeasurements, allowMultiSelect, childDataCallback, columns, sortOrders, allowSortOnMultiColumns) {
            this.height = height;
            this.sharedMeasurements = sharedMeasurements;
            this.allowMultiSelect = allowMultiSelect;
            this.childDataCallback = childDataCallback;
            this.columns = columns;
            this.sortOrders = sortOrders;
            this.allowSortOnMultiColumns = allowSortOnMultiColumns;
            this.sizeColumns();
        }
        GridOptions.prototype.sizeColumns = function () {
            if(this.columns) {
                var maxWidth = document.documentElement.offsetWidth - 33;
                var usedWidth = 0;
                var variableWidthIndex = -1;
                for(var i = 0; i < this.columns.length; i++) {
                    if(this.columns[i].variableWidth && variableWidthIndex === -1) {
                        variableWidthIndex = i;
                    } else {
                        usedWidth += this.columns[i].width;
                    }
                }
                if(variableWidthIndex >= 0) {
                    var targetWidth = maxWidth - usedWidth;
                    if(targetWidth > this.columns[variableWidthIndex].width) {
                        this.columns[variableWidthIndex].width = targetWidth;
                    }
                }
            }
        };
        return GridOptions;
    })();
    MemoryAnalyzer.GridOptions = GridOptions;    
    var GridContextMenuData = (function () {
        function GridContextMenuData(view, objectId, parentObjectId) {
            this.view = view;
            this.objectId = objectId;
            this.parentObjectId = parentObjectId;
        }
        return GridContextMenuData;
    })();
    MemoryAnalyzer.GridContextMenuData = GridContextMenuData;    
    var SnapshotDataViewController = (function () {
        function SnapshotDataViewController(viewType, snapshot, viewSwitcher, displayObjectIDs, showBuiltIns) {
            this._viewType = viewType;
            this._dataSource = MemoryAnalyzer.SnapshotDataSource.getDataSource(viewType, snapshot);
            this._viewSwitcher = viewSwitcher;
            this.model = new SnapshotDataViewModel(this._viewType, snapshot.isDiff);
            this.model.isChangedOnly = false;
            this.model.displayObjectIDs = displayObjectIDs;
            this.model.showBuiltIns = showBuiltIns;
            this.model.showUnknownTypes = MemoryAnalyzer.Program.userSettings.showUnknownTypes;
            this.model.showUnknownSizes = MemoryAnalyzer.Program.userSettings.showUnknownSizes;
            this.view = new SnapshotDataView(this, this.model);
        }
        SnapshotDataViewController.prototype.setSnapshotDataSource = function () {
            this.model.snapshotDataSource = this._dataSource;
            this.view.refreshGrids();
        };
        SnapshotDataViewController.prototype.showPathToRoot = function (objectId, parentObjectId) {
            this._viewSwitcher.switchToView(MemoryAnalyzer.DataViewType.roots);
            this._viewSwitcher.currentView.showPathToRoot(objectId, parentObjectId);
        };
        Object.defineProperty(SnapshotDataViewController.prototype, "currentView", {
            get: function () {
                return this._viewSwitcher.currentView;
            },
            enumerable: true,
            configurable: true
        });
        return SnapshotDataViewController;
    })();
    MemoryAnalyzer.SnapshotDataViewController = SnapshotDataViewController;    
    var SnapshotDataViewModel = (function (_super) {
        __extends(SnapshotDataViewModel, _super);
        function SnapshotDataViewModel(viewType, isDiff) {
            if (typeof isDiff === "undefined") { isDiff = false; }
                _super.call(this);
            this.viewType = viewType;
            this._isDiff = isDiff;
        }
        Object.defineProperty(SnapshotDataViewModel.prototype, "isChangedOnly", {
            get: function () {
                return this._isChangedOnly;
            },
            set: function (v) {
                if(this._isChangedOnly !== v) {
                    this._isChangedOnly = v;
                    this.raisePropertyChanged("isChangedOnly");
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SnapshotDataViewModel.prototype, "showBuiltIns", {
            get: function () {
                return this._showBuiltIns;
            },
            set: function (v) {
                if(this._showBuiltIns !== v) {
                    this._showBuiltIns = v;
                    this.raisePropertyChanged("showBuiltIns");
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SnapshotDataViewModel.prototype, "displayObjectIDs", {
            get: function () {
                return this._displayObjectIDs;
            },
            set: function (v) {
                if(this._displayObjectIDs !== v) {
                    this._displayObjectIDs = v;
                    this.raisePropertyChanged("displayObjectIDs");
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SnapshotDataViewModel.prototype, "showUnknownTypes", {
            get: function () {
                return this._showUnknownTypes;
            },
            set: function (v) {
                if(this._showUnknownTypes !== v) {
                    this._showUnknownTypes = v;
                    this.raisePropertyChanged("showUnknownTypes");
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SnapshotDataViewModel.prototype, "showUnknownSizes", {
            get: function () {
                return this._showUnknownSizes;
            },
            set: function (v) {
                if(this._showUnknownSizes !== v) {
                    this._showUnknownSizes = v;
                    this.raisePropertyChanged("showUnknownSizes");
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SnapshotDataViewModel.prototype, "filterString", {
            get: function () {
                return this._filterString;
            },
            set: function (v) {
                if(this._filterString !== v) {
                    this._filterString = v;
                    this.raisePropertyChanged("filterString");
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SnapshotDataViewModel.prototype, "snapshotDataSource", {
            get: function () {
                return this._snapshotDataSource;
            },
            set: function (v) {
                if(this._snapshotDataSource !== v) {
                    this._snapshotDataSource = v;
                    this.raisePropertyChanged("snapshotDataSource");
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SnapshotDataViewModel.prototype, "isDiff", {
            get: function () {
                return this._isDiff;
            },
            set: function (v) {
                if(this._isDiff !== v) {
                    this._isDiff = v;
                    this.raisePropertyChanged("isDiff");
                }
            },
            enumerable: true,
            configurable: true
        });
        SnapshotDataViewModel.prototype.onPropertyChanged = function (propertyName) {
            switch(propertyName) {
                case "displayObjectIDs": {
                    this.displayObjectIDs = !this._displayObjectIDs;
                    break;

                }
                case "showBuiltIns": {
                    this.showBuiltIns = !this._showBuiltIns;
                    break;

                }
            }
        };
        return SnapshotDataViewModel;
    })(MemoryAnalyzer.Controls.ObservableViewModel);
    MemoryAnalyzer.SnapshotDataViewModel = SnapshotDataViewModel;    
    var SnapshotDataView = (function (_super) {
        __extends(SnapshotDataView, _super);
        function SnapshotDataView(controller, model) {
            var _this = this;
                _super.call(this, "SnapshotDataViewTemplate");
            this._fieldNameToColumnMapMainGrid = {
            };
            this._fieldNameToColumnMapReferenceGrid = {
            };
            this._controller = controller;
            this._model = model;
            this._model.registerPropertyChanged(this);
            this._snapshotViewContainer = this.findElement("snapshotViewContainer");
            this._referenceViewContainer = this.findElement("referenceViewContainer");
            this._filterInput = this.findElement("filterInput");
            this._filterInput.placeholder = Plugin.Resources.getString("IdentifierFilter");
            this._filterInput.setAttribute("aria-label", Plugin.Resources.getString("IdentifierFilter"));
            this.findElement("referenceGraphTitleLabel").innerText = Plugin.Resources.getString("ReferenceGraph");
            this._snapshotViewGridSplitter = new MemoryAnalyzer.Controls.GridSplitterControl(this.findElement("snapshotViewGridSplitter"), null, this.refreshGrids.bind(this));
            var giveFeedbackButton = this.findElement("giveFeedbackButton_Detail");
            if(this._model.viewType === MemoryAnalyzer.DataViewType.roots) {
                this._filterInput.disabled = true;
                this._filterInput.classList.add("hidden");
            } else {
                this._filterInput.onkeyup = this.onFilterInputChanged.bind(this);
                this._filterInput.classList.remove("hidden");
            }
            giveFeedbackButton.classList.add("hidden");
            MemoryAnalyzer.Extensions.InternalFeedbackHelper.isEnabled().done(function (isEnabled) {
                if(isEnabled) {
                    giveFeedbackButton.classList.remove("hidden");
                    giveFeedbackButton.addEventListener("click", _this.onGiveFeedbackClick.bind(_this));
                }
            });
            if(!SnapshotDataView._gridContextMenu) {
                SnapshotDataView._gridContextMenu = Plugin.VS.Commands.bindContextMenu("gridcontextmenu");
                SnapshotDataView._showInRootsViewCommand = Plugin.VS.Commands.bindCommand({
                    name: "showinrootsviewcommand",
                    onexecute: SnapshotDataView.onShowInRootsViewCommand,
                    enabled: true
                });
            }
            if(this._model.isDiff) {
                if(this._model.viewType === MemoryAnalyzer.DataViewType.types) {
                    this._sortOrder = new SortOrderInfo("childrenCountDiff", "desc");
                } else {
                    this._sortOrder = new SortOrderInfo("retainedSizeDiff", "desc");
                }
            } else {
                if(this._model.viewType === MemoryAnalyzer.DataViewType.types) {
                    this._sortOrder = new SortOrderInfo("childrenCount", "desc");
                } else {
                    this._sortOrder = new SortOrderInfo("retainedSize", "desc");
                }
            }
            this._sortOrderForReferences = new SortOrderInfo("retainedSize", "desc");
            this.uiUpdateSnapshotDataSource();
        }
        SnapshotDataView._gridContextMenu = null;
        SnapshotDataView._showInRootsViewCommand = null;
        SnapshotDataView._gridContextMenuData = null;
        SnapshotDataView.prototype.onPropertyChanged = function (propertyName) {
            switch(propertyName) {
                case "isChangedOnly":
                case "isDiff":
                case "showBuiltIns":
                case "showUnknownTypes":
                case "showUnknownSizes":
                case "snapshotDataSource":
                case "filterString":
                case "displayObjectIDs": {
                    this.uiUpdateSnapshotDataSource();
                    break;

                }
            }
        };
        SnapshotDataView.prototype.refreshGrids = function () {
            if(this._grid) {
                this._grid.layout();
                this._filterInput.focus();
            }
            if(this._gridReference) {
                this._gridReference.layout();
            }
        };
        SnapshotDataView.prototype.showPathToRoot = function (objectId, parentObjectId) {
            var path = this._model.snapshotDataSource.snapshot.getPathToRoot(objectId, this.getFilter(), parentObjectId);
            if(path && path.length > 0) {
                var pathFromRoot = path.reverse();
                var dataSource = (this._grid)._dataSource;
                var expandStates = this._grid.getExpandStates();
                var dataSourceIndex = 0;
                for(var pathIndex = 0; pathIndex < pathFromRoot.length; pathIndex++) {
                    for(; dataSourceIndex < dataSource.length; dataSourceIndex++) {
                        if(dataSource[dataSourceIndex].objectId === pathFromRoot[pathIndex]) {
                            if(pathIndex === pathFromRoot.length - 1) {
                                this._grid.setSelectedDataIndex(dataSourceIndex);
                            } else {
                                if(expandStates[dataSourceIndex] < 0) {
                                    this._grid.expandNode(dataSourceIndex);
                                }
                                dataSourceIndex++;
                            }
                            break;
                        } else {
                            if(expandStates[dataSourceIndex] !== 0) {
                                dataSourceIndex += Math.abs(expandStates[dataSourceIndex]) - 1;
                            }
                        }
                    }
                }
                this._grid.layout();
                this._grid.getSelectedRowIntoView();
                window.setTimeout((function () {
                    var rowInfo = this._grid.getRowInfo(dataSourceIndex);
                    if(rowInfo && rowInfo.row && rowInfo.row[0]) {
                        rowInfo.row[0].click();
                    }
                }).bind(this), 0);
            }
        };
        SnapshotDataView.prototype.onGiveFeedbackClick = function (e) {
            var _this = this;
            MemoryAnalyzer.Extensions.InternalFeedbackHelper.isEnabled().done(function (enabled) {
                if(enabled) {
                    MemoryAnalyzer.Extensions.Session.save(false).done(function (fileLocation) {
                        MemoryAnalyzer.Extensions.InternalFeedbackHelper.sendData(true, "", "", Common.Enum.GetName(MemoryAnalyzer.DataViewType, _this._model.viewType), "", fileLocation);
                    });
                }
            });
        };
        SnapshotDataView.prototype.onGridContextMenu = function (grid, e) {
            if(this._model.viewType !== MemoryAnalyzer.DataViewType.roots || grid === this._gridReference) {
                var dataIndex = grid.getSelectedDataIndex();
                var foundRow = false;
                var menuX = e.screenX;
                var menuY = e.screenY;
                if(e.clientX === 0 && e.clientY === 0) {
                    foundRow = (dataIndex > -1);
                    var row = grid.getRowInfo(dataIndex).row[0];
                    var rect = row.getBoundingClientRect();
                    menuX = Math.round(window.screenLeft + rect.left + (rect.width / 2));
                    menuY = Math.round(window.screenTop + rect.top + (rect.height / 2));
                } else {
                    var clickedElement = document.elementFromPoint(e.clientX, e.clientY);
                    while(clickedElement) {
                        if(clickedElement && clickedElement.classList) {
                            if(clickedElement.classList.contains("grid-row")) {
                                foundRow = true;
                                break;
                            } else {
                                if(clickedElement.classList.contains("grid-canvas")) {
                                    break;
                                }
                            }
                        }
                        clickedElement = clickedElement.parentElement;
                    }
                }
                if(foundRow) {
                    var objectId = -1;
                    if(typeof dataIndex === "number" && dataIndex >= 0) {
                        var obj = grid.getRowData(dataIndex);
                        if(!(obj instanceof MemoryAnalyzer.TypeDataObject)) {
                            objectId = obj.objectId;
                        }
                    }
                    if(objectId >= 0) {
                        SnapshotDataView._gridContextMenuData = new GridContextMenuData(this, objectId, obj.parentObjectId);
                        SnapshotDataView._gridContextMenu.show(menuX, menuY);
                    } else {
                        SnapshotDataView._gridContextMenuData = null;
                    }
                }
            }
            e.preventDefault();
            e.stopImmediatePropagation();
            return false;
        };
        SnapshotDataView.prototype.uiUpdateAll = function () {
            this.uiUpdateSnapshotDataSource();
        };
        SnapshotDataView.prototype.uiUpdateSnapshotDataSource = function () {
            if(this._model.snapshotDataSource) {
                this._model.isChangedOnly = this._model.snapshotDataSource.snapshot.isDiff;
                this._fieldNameToColumnMapMainGrid = SnapshotDataView.populateFieldNameToColumnMap(this._model.isChangedOnly);
                this._fieldNameToColumnMapReferenceGrid = SnapshotDataView.populateFieldNameToColumnMap(this._model.isChangedOnly);
            }
            this._referenceViewContainer.style.display = "none";
            this.updateTree();
        };
        SnapshotDataView.prototype.onFilterInputChanged = function (eventArgs) {
            if(eventArgs.keyCode === KeyCodes.ESCAPE) {
                this._filterInput.value = "";
                this._grid.focus();
            }
            this._model.filterString = this._filterInput.value;
        };
        SnapshotDataView.prototype.getFilter = function () {
            return {
                displayObjectIDs: this._model.displayObjectIDs,
                isChangedOnly: this._model.isChangedOnly,
                showBuiltIns: this._model.showBuiltIns,
                showUnknownTypes: this._model.showUnknownTypes,
                showUnknownSizes: this._model.showUnknownSizes,
                filterString: this._model.filterString
            };
        };
        SnapshotDataView.prototype.getSorter = function () {
            return {
                sortProperty: this._sortOrder.index,
                sortOrder: this._sortOrder.order === "asc" ? MemoryAnalyzer.SortOrderType.ascending : MemoryAnalyzer.SortOrderType.descending,
                sortComparer: SnapshotDataView.getSortComparer(this._sortOrder, this._fieldNameToColumnMapMainGrid)
            };
        };
        SnapshotDataView.prototype.getSorterForReferences = function () {
            return {
                sortProperty: this._sortOrderForReferences.index,
                sortOrder: this._sortOrderForReferences.order === "asc" ? MemoryAnalyzer.SortOrderType.ascending : MemoryAnalyzer.SortOrderType.descending,
                sortComparer: SnapshotDataView.getSortComparer(this._sortOrderForReferences, this._fieldNameToColumnMapReferenceGrid)
            };
        };
        SnapshotDataView.prototype.updateTree = function () {
            if(!this._model.snapshotDataSource) {
                return;
            }
            var roots = this._model.snapshotDataSource.getRootHeapDataTreeItem(this.getFilter(), this.getSorter());
            var getChildren = function (item) {
                return this._model.snapshotDataSource.getHeapDataTreeItem(this.getFilter(), this.getSorter(), item.id);
            };
            var treeInfo = this.getTreeInfo(roots, getChildren.bind(this));
            var columns = this.getColumnInfoForMainGrid(this._model.snapshotDataSource.getAvailableFields());
            var gridOptions = new GridOptions("100%", false, false, treeInfo.toggleFunction.bind(this), columns, [
                this._sortOrder
            ], false);
            if(!this._grid) {
                this._grid = this.createGrid(treeInfo.gridData, treeInfo.expandStates, gridOptions, this._snapshotViewContainer);
                this._grid.getElement().tabIndex = 4;
                this._grid.getElement().bind("sort", this.sortCompleted.bind(this));
                this._grid.getElement().bind("selectionchanged", this.onGridSelectionChanged.bind(this));
            } else {
                this._grid.setDataSource(treeInfo.gridData, treeInfo.expandStates, gridOptions.columns, gridOptions.sortOrders);
            }
        };
        SnapshotDataView.prototype.onGridSelectionChanged = function (sender, args) {
            var item;
            if(args.selectedCount === 1) {
                var dataIndex = args.selectedRows[args.selectedIndex];
                if(typeof dataIndex !== "undefined") {
                    item = this._grid.getRowData(dataIndex);
                }
            }
            this.showReferences(item);
        };
        SnapshotDataView.prototype.showReferences = function (item) {
            var items;
            if(item) {
                items = this._model.snapshotDataSource.getReferenceTreeItems(item.id, this.getSorterForReferences(), this._model.displayObjectIDs);
            }
            if(!items || items.length === 0) {
                this._referenceViewContainer.style.display = "none";
                return;
            }
            var getChildren = function (parentItem) {
                return this._model.snapshotDataSource.getReferenceTreeItems.call(this._model.snapshotDataSource, (parentItem).parentObjectId, this.getSorterForReferences(), this._model.displayObjectIDs);
            };
            var treeInfo = this.getTreeInfo(items, getChildren.bind(this));
            var columns = this.getColumnInfoForReferenceGrid(this._model.snapshotDataSource.getAvailableFieldsForReferenceTree());
            var gridOptions = new GridOptions("100%", false, false, treeInfo.toggleFunction.bind(this), columns, [
                this._sortOrderForReferences
            ], false);
            if(!this._gridReference) {
                this._gridReference = this.createGrid(treeInfo.gridData, treeInfo.expandStates, gridOptions, this._referenceViewContainer);
                this._gridReference.getElement().tabIndex = 4;
                this._gridReference.getElement().bind("sort", this.sortCompletedForReferences.bind(this));
            } else {
                this._gridReference.setDataSource(treeInfo.gridData, treeInfo.expandStates, gridOptions.columns, gridOptions.sortOrders);
            }
            this._referenceViewContainer.style.removeProperty("display");
            if(items.length === 1 && items[0].hasChildrenWhenFiltered) {
                this._gridReference.expandNode(0);
            }
        };
        SnapshotDataView.prototype.getTreeInfo = function (roots, getChildren) {
            var rowsAndExpandStates = this.getPlaceholderRowsAndExpandStates(roots);
            var items = rowsAndExpandStates.itemsWithPlaceholders;
            var expandStates = rowsAndExpandStates.expandStates;
            var toggleFunction = function (parentTreeItem) {
                var childItems = getChildren(parentTreeItem);
                return this.getPlaceholderRowsAndExpandStates(childItems);
            };
            return new TreeInfo(items, expandStates, toggleFunction);
        };
        SnapshotDataView.prototype.getPlaceholderRowsAndExpandStates = function (roots) {
            var items = [];
            var placeHolderRow = {
                name: "",
                value: "",
                isPlaceholder: true
            };
            var expandStates = [];
            for(var i = 0; roots && i < roots.length; i++) {
                items.push(roots[i]);
                if(roots[i].hasChildrenWhenFiltered) {
                    expandStates.push(-1);
                    items.push(placeHolderRow);
                    expandStates.push(0);
                } else {
                    expandStates.push(0);
                }
            }
            return {
                itemsWithPlaceholders: items,
                expandStates: expandStates
            };
        };
        SnapshotDataView.prototype.createGrid = function (gridData, expandStates, gridOptions, container) {
            container.innerHTML = "";
            var grid;
            TFS.using([
                "TFS.UI.Controls.Grids"
            ], (function () {
                grid = TFS.UI.Controls.Grids.Grid.createIn(container, gridOptions);
                grid.setDataSource(gridData, expandStates, gridOptions.columns, gridOptions.sortOrders);
            }).bind(this));
            container.addEventListener("contextmenu", this.onGridContextMenu.bind(this, grid));
            return grid;
        };
        SnapshotDataView.prototype.getColumnInfo = function (fieldNames, fieldNamesToColumnInfo) {
            var columnInfo = new Array();
            for(var i = 0; i < fieldNames.length; i++) {
                if(fieldNamesToColumnInfo.hasOwnProperty(fieldNames[i])) {
                    columnInfo.push(fieldNamesToColumnInfo[fieldNames[i]]);
                } else {
                    throw new Error(Plugin.Resources.getErrorString("JSPerf.1003"));
                }
            }
            return columnInfo;
        };
        SnapshotDataView.prototype.getColumnInfoForMainGrid = function (fieldNames) {
            return this.getColumnInfo(fieldNames, this._fieldNameToColumnMapMainGrid);
        };
        SnapshotDataView.prototype.getColumnInfoForReferenceGrid = function (fieldNames) {
            return this.getColumnInfo(fieldNames, this._fieldNameToColumnMapReferenceGrid);
        };
        SnapshotDataView.prototype.sortCompleted = function (event, data) {
            this._sortOrder = data.sortOrder[0];
            MemoryAnalyzer.Program.onIdle();
        };
        SnapshotDataView.prototype.sortCompletedForReferences = function (event, data) {
            this._sortOrderForReferences = data.sortOrder[0];
        };
        SnapshotDataView.getSortComparer = function getSortComparer(sortOrder, fieldNameToColumnMap) {
            var column = fieldNameToColumnMap[sortOrder.index], comparer = column.comparer, isAsc = sortOrder.order === "asc";
            return function (v1, v2) {
                var result = comparer(column, sortOrder.order, v1, v2);
                return isAsc ? result : -result;
            }
        }
        SnapshotDataView.populateFieldNameToColumnMap = function populateFieldNameToColumnMap(modelIsChangedOnly) {
            var fieldNameToColumnMap = {
            };
            fieldNameToColumnMap["name"] = new ColumnInfo("name", Plugin.Resources.getString("Identifiers"), Plugin.Resources.getString("IdentifiersTooltip"), 350, true, null, modelIsChangedOnly ? SnapshotDataView.getDiffNameCellCSSClass : null, SnapshotDataView.columnComparerForStrings, true);
            fieldNameToColumnMap["type"] = new ColumnInfo("type", Plugin.Resources.getString("Type"), Plugin.Resources.getString("TypeTooltip"), 150, true, null, null, SnapshotDataView.columnComparerForStrings);
            fieldNameToColumnMap["size"] = new ColumnInfo("size", Plugin.Resources.getString("Size"), Plugin.Resources.getString("SizeTooltip"), 100, true, SnapshotDataView.formatSize, null, SnapshotDataView.columnComparerForNumbers);
            fieldNameToColumnMap["retainedSize"] = new ColumnInfo("retainedSize", Plugin.Resources.getString("RetainedSize"), Plugin.Resources.getString("RetainedSizeTooltip"), 100, true, SnapshotDataView.formatRetainedSize, null, SnapshotDataView.columnComparerForNumbers);
            fieldNameToColumnMap["childrenCount"] = new ColumnInfo("childrenCount", Plugin.Resources.getString("Count"), Plugin.Resources.getString("CountTooltip"), 50, true, SnapshotDataView.formatChildrenCount, null, SnapshotDataView.columnComparerForNumbers);
            fieldNameToColumnMap["sizeDiff"] = new ColumnInfo("sizeDiff", Plugin.Resources.getString("SizeDiff"), Plugin.Resources.getString("SizeDiffTooltip"), 100, true, SnapshotDataView.formatSizeDiff, null, SnapshotDataView.columnComparerForNumbers);
            fieldNameToColumnMap["retainedSizeDiff"] = new ColumnInfo("retainedSizeDiff", Plugin.Resources.getString("RetainedSizeDiff"), Plugin.Resources.getString("RetainedSizeDiffTooltip"), 150, true, SnapshotDataView.formatRetainedSizeDiff, null, SnapshotDataView.columnComparerForNumbers);
            fieldNameToColumnMap["childrenCountDiff"] = new ColumnInfo("childrenCountDiff", Plugin.Resources.getString("CountDiff"), Plugin.Resources.getString("CountDiffTooltip"), 100, true, SnapshotDataView.formatChildrenCountDiff, null, SnapshotDataView.columnComparerForNumbers);
            return fieldNameToColumnMap;
        }
        SnapshotDataView.columnComparerForNumbers = function columnComparerForNumbers(column, order, rowA, rowB) {
            var n1 = rowA[column.index] || 0, n2 = rowB[column.index] || 0;
            return n1 - n2;
        }
        SnapshotDataView.columnComparerForStrings = function columnComparerForStrings(column, order, rowA, rowB) {
            return SnapshotDataView.naturalSort(rowA[column.index], rowB[column.index]);
        }
        SnapshotDataView.naturalSort = function naturalSort(a, b) {
            var regexSortGroup = /(\d+)|(\D+)/g;
            var aGroups = String(a).toLowerCase().match(regexSortGroup);
            var bGroups = String(b).toLowerCase().match(regexSortGroup);
            while(aGroups.length > 0 && bGroups.length > 0) {
                var aFront = aGroups.shift();
                var bFront = bGroups.shift();
                var aAsDigit = parseInt(aFront, 10);
                var bAsDigit = parseInt(bFront, 10);
                if(isNaN(aAsDigit) && isNaN(bAsDigit)) {
                    if(aFront !== bFront) {
                        return (aFront > bFront ? 1 : -1);
                    }
                } else {
                    if(isNaN(aAsDigit)) {
                        return 1;
                    } else {
                        if(isNaN(bAsDigit)) {
                            return -1;
                        } else {
                            if(aAsDigit !== bAsDigit) {
                                return (aAsDigit - bAsDigit);
                            }
                        }
                    }
                }
            }
            return aGroups.length - bGroups.length;
        }
        SnapshotDataView.onShowInRootsViewCommand = function onShowInRootsViewCommand() {
            if(SnapshotDataView._gridContextMenuData && SnapshotDataView._gridContextMenuData.view) {
                SnapshotDataView._gridContextMenuData.view._controller.showPathToRoot(SnapshotDataView._gridContextMenuData.objectId, SnapshotDataView._gridContextMenuData.parentObjectId);
                SnapshotDataView._gridContextMenuData = null;
            }
        }
        SnapshotDataView.formatChildrenCount = function formatChildrenCount(dataIndex, columnIndex, columnOrder, dataSource, isForTooltip) {
            var originalItem = dataSource[dataIndex];
            if(originalItem.childrenCount) {
                return MemoryAnalyzer.FormattingHelpers.getDecimalLocaleString(originalItem.childrenCount, true);
            } else {
                return "";
            }
        }
        SnapshotDataView.formatChildrenCountDiff = function formatChildrenCountDiff(dataIndex, columnIndex, columnOrder, dataSource, isForTooltip) {
            var originalItem = dataSource[dataIndex];
            if(originalItem.childrenCountDiff) {
                return (originalItem.childrenCountDiff > 0 ? "+" : "-") + MemoryAnalyzer.FormattingHelpers.getDecimalLocaleString(originalItem.childrenCountDiff, true);
            } else {
                return "";
            }
        }
        SnapshotDataView.formatSize = function formatSize(dataIndex, columnIndex, columnOrder, dataSource, isForTooltip) {
            var originalItem = dataSource[dataIndex];
            if(originalItem.size) {
                var text = MemoryAnalyzer.FormattingHelpers.getPrettyPrintSize(originalItem.size) + (originalItem.sizeIsApproximate ? "*" : " ");
                if(isForTooltip && originalItem.sizeIsApproximate) {
                    text = Plugin.Resources.getString("ApproximateSizeTooltip", text);
                }
                return text;
            } else {
                return "";
            }
        }
        SnapshotDataView.formatRetainedSize = function formatRetainedSize(dataIndex, columnIndex, columnOrder, dataSource, isForTooltip) {
            var namedHeapObject = dataSource[dataIndex];
            if(namedHeapObject.retainedSize) {
                return MemoryAnalyzer.FormattingHelpers.getPrettyPrintSize(namedHeapObject.retainedSize);
            } else {
                return "";
            }
        }
        SnapshotDataView.formatRetainedSizeDiff = function formatRetainedSizeDiff(dataIndex, columnIndex, columnOrder, dataSource, isForTooltip) {
            var namedHeapObject = dataSource[dataIndex];
            if(namedHeapObject.retainedSizeDiff) {
                return (namedHeapObject.retainedSizeDiff > 0 ? "+" : "-") + MemoryAnalyzer.FormattingHelpers.getPrettyPrintSize(Math.abs(namedHeapObject.retainedSizeDiff));
            } else {
                return "";
            }
        }
        SnapshotDataView.formatSizeDiff = function formatSizeDiff(dataIndex, columnIndex, columnOrder, dataSource, isForTooltip) {
            var namedHeapObject = dataSource[dataIndex];
            if(namedHeapObject.sizeDiff) {
                return (namedHeapObject.sizeDiff > 0 ? "+" : "-") + MemoryAnalyzer.FormattingHelpers.getPrettyPrintSize(Math.abs(namedHeapObject.sizeDiff));
            } else {
                return "";
            }
        }
        SnapshotDataView.getDiffNameCellCSSClass = function getDiffNameCellCSSClass(dataIndex, columnIndex, columnOrder, dataSource) {
            var item = dataSource[dataIndex];
            if(item.isRelatedToChanged) {
                return "diff-unchangedObjectStyle";
            }
            return null;
        }
        return SnapshotDataView;
    })(Common.Controls.TemplateControl);
    MemoryAnalyzer.SnapshotDataView = SnapshotDataView;    
})(MemoryAnalyzer || (MemoryAnalyzer = {}));
//@ sourceMappingURL=snapshotDataView.js.map

// SIG // Begin signature block
// SIG // MIIanQYJKoZIhvcNAQcCoIIajjCCGooCAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFMTiIN+CEOaO
// SIG // MvGp0/7R3lOFGFX6oIIVeTCCBLowggOioAMCAQICCmEC
// SIG // kkoAAAAAACAwDQYJKoZIhvcNAQEFBQAwdzELMAkGA1UE
// SIG // BhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNV
// SIG // BAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBD
// SIG // b3Jwb3JhdGlvbjEhMB8GA1UEAxMYTWljcm9zb2Z0IFRp
// SIG // bWUtU3RhbXAgUENBMB4XDTEyMDEwOTIyMjU1OVoXDTEz
// SIG // MDQwOTIyMjU1OVowgbMxCzAJBgNVBAYTAlVTMRMwEQYD
// SIG // VQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25k
// SIG // MR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24x
// SIG // DTALBgNVBAsTBE1PUFIxJzAlBgNVBAsTHm5DaXBoZXIg
// SIG // RFNFIEVTTjpCOEVDLTMwQTQtNzE0NDElMCMGA1UEAxMc
// SIG // TWljcm9zb2Z0IFRpbWUtU3RhbXAgU2VydmljZTCCASIw
// SIG // DQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAM1jw/ei
// SIG // tUfZ+TmUU6xrj6Z5OCH00W49FTgWwXMsmY/74Dxb4aJM
// SIG // i7Kri7TySse5k1DRJvWHU7B6dfNHDxcrZyxk62DnSozg
// SIG // i17EVmk3OioEXRcByL+pt9PJq6ORqIHjPy232OTEeAB5
// SIG // Oc/9x2TiIxJ4ngx2J0mPmqwOdOMGVVVJyO2hfHBFYX6y
// SIG // cRYe4cFBudLSMulSJPM2UATX3W88SdUL1HZA/GVlE36V
// SIG // UTrV/7iap1drSxXlN1gf3AANxa7q34FH+fBSrubPWqzg
// SIG // FEqmcZSA+v2wIzBg6YNgrA4kHv8R8uelVWKV7p9/ninW
// SIG // zUsKdoPwQwTfBkkg8lNaRLBRejkCAwEAAaOCAQkwggEF
// SIG // MB0GA1UdDgQWBBTNGaxhTZRnK/avlHVZ2/BYAIOhOjAf
// SIG // BgNVHSMEGDAWgBQjNPjZUkZwCu1A+3b7syuwwzWzDzBU
// SIG // BgNVHR8ETTBLMEmgR6BFhkNodHRwOi8vY3JsLm1pY3Jv
// SIG // c29mdC5jb20vcGtpL2NybC9wcm9kdWN0cy9NaWNyb3Nv
// SIG // ZnRUaW1lU3RhbXBQQ0EuY3JsMFgGCCsGAQUFBwEBBEww
// SIG // SjBIBggrBgEFBQcwAoY8aHR0cDovL3d3dy5taWNyb3Nv
// SIG // ZnQuY29tL3BraS9jZXJ0cy9NaWNyb3NvZnRUaW1lU3Rh
// SIG // bXBQQ0EuY3J0MBMGA1UdJQQMMAoGCCsGAQUFBwMIMA0G
// SIG // CSqGSIb3DQEBBQUAA4IBAQBRHNbfNh3cgLwCp8aZ3xbI
// SIG // kAZpFZoyufNkENKK82IpG3mPymCps13E5BYtNYxEm/H0
// SIG // XGGkQa6ai7pQ0Wp5arNijJ1NUVALqY7Uv6IQwEfVTnVS
// SIG // iR4/lmqPLkAUBnLuP3BZkl2F7YOZ+oKEnuQDASETqyfW
// SIG // zHFJ5dod/288CU7VjWboDMl/7jEUAjdfe2nsiT5FfyVE
// SIG // 5x8a1sUaw0rk4fGEmOdP+amYpxhG7IRs7KkDCv18elId
// SIG // nGukqA+YkqSSeFwreON9ssfZtnB931tzU7+q1GZQS/DJ
// SIG // O5WF5cFKZZ0lWFC7IFSReTobB1xqVyivMcef58Md7kf9
// SIG // J9d/z3TcZcU/MIIE7DCCA9SgAwIBAgITMwAAALARrwqL
// SIG // 0Duf3QABAAAAsDANBgkqhkiG9w0BAQUFADB5MQswCQYD
// SIG // VQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4G
// SIG // A1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
// SIG // IENvcnBvcmF0aW9uMSMwIQYDVQQDExpNaWNyb3NvZnQg
// SIG // Q29kZSBTaWduaW5nIFBDQTAeFw0xMzAxMjQyMjMzMzla
// SIG // Fw0xNDA0MjQyMjMzMzlaMIGDMQswCQYDVQQGEwJVUzET
// SIG // MBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVk
// SIG // bW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0
// SIG // aW9uMQ0wCwYDVQQLEwRNT1BSMR4wHAYDVQQDExVNaWNy
// SIG // b3NvZnQgQ29ycG9yYXRpb24wggEiMA0GCSqGSIb3DQEB
// SIG // AQUAA4IBDwAwggEKAoIBAQDor1yiIA34KHy8BXt/re7r
// SIG // dqwoUz8620B9s44z5lc/pVEVNFSlz7SLqT+oN+EtUO01
// SIG // Fk7vTXrbE3aIsCzwWVyp6+HXKXXkG4Unm/P4LZ5BNisL
// SIG // QPu+O7q5XHWTFlJLyjPFN7Dz636o9UEVXAhlHSE38Cy6
// SIG // IgsQsRCddyKFhHxPuRuQsPWj/ov0DJpOoPXJCiHiquMB
// SIG // Nkf9L4JqgQP1qTXclFed+0vUDoLbOI8S/uPWenSIZOFi
// SIG // xCUuKq6dGB8OHrbCryS0DlC83hyTXEmmebW22875cHso
// SIG // AYS4KinPv6kFBeHgD3FN/a1cI4Mp68fFSsjoJ4TTfsZD
// SIG // C5UABbFPZXHFAgMBAAGjggFgMIIBXDATBgNVHSUEDDAK
// SIG // BggrBgEFBQcDAzAdBgNVHQ4EFgQUWXGmWjNN2pgHgP+E
// SIG // Hr6H+XIyQfIwUQYDVR0RBEowSKRGMEQxDTALBgNVBAsT
// SIG // BE1PUFIxMzAxBgNVBAUTKjMxNTk1KzRmYWYwYjcxLWFk
// SIG // MzctNGFhMy1hNjcxLTc2YmMwNTIzNDRhZDAfBgNVHSME
// SIG // GDAWgBTLEejK0rQWWAHJNy4zFha5TJoKHzBWBgNVHR8E
// SIG // TzBNMEugSaBHhkVodHRwOi8vY3JsLm1pY3Jvc29mdC5j
// SIG // b20vcGtpL2NybC9wcm9kdWN0cy9NaWNDb2RTaWdQQ0Ff
// SIG // MDgtMzEtMjAxMC5jcmwwWgYIKwYBBQUHAQEETjBMMEoG
// SIG // CCsGAQUFBzAChj5odHRwOi8vd3d3Lm1pY3Jvc29mdC5j
// SIG // b20vcGtpL2NlcnRzL01pY0NvZFNpZ1BDQV8wOC0zMS0y
// SIG // MDEwLmNydDANBgkqhkiG9w0BAQUFAAOCAQEAMdduKhJX
// SIG // M4HVncbr+TrURE0Inu5e32pbt3nPApy8dmiekKGcC8N/
// SIG // oozxTbqVOfsN4OGb9F0kDxuNiBU6fNutzrPJbLo5LEV9
// SIG // JBFUJjANDf9H6gMH5eRmXSx7nR2pEPocsHTyT2lrnqkk
// SIG // hNrtlqDfc6TvahqsS2Ke8XzAFH9IzU2yRPnwPJNtQtjo
// SIG // fOYXoJtoaAko+QKX7xEDumdSrcHps3Om0mPNSuI+5PNO
// SIG // /f+h4LsCEztdIN5VP6OukEAxOHUoXgSpRm3m9Xp5QL0f
// SIG // zehF1a7iXT71dcfmZmNgzNWahIeNJDD37zTQYx2xQmdK
// SIG // Dku/Og7vtpU6pzjkJZIIpohmgjCCBbwwggOkoAMCAQIC
// SIG // CmEzJhoAAAAAADEwDQYJKoZIhvcNAQEFBQAwXzETMBEG
// SIG // CgmSJomT8ixkARkWA2NvbTEZMBcGCgmSJomT8ixkARkW
// SIG // CW1pY3Jvc29mdDEtMCsGA1UEAxMkTWljcm9zb2Z0IFJv
// SIG // b3QgQ2VydGlmaWNhdGUgQXV0aG9yaXR5MB4XDTEwMDgz
// SIG // MTIyMTkzMloXDTIwMDgzMTIyMjkzMloweTELMAkGA1UE
// SIG // BhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNV
// SIG // BAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBD
// SIG // b3Jwb3JhdGlvbjEjMCEGA1UEAxMaTWljcm9zb2Z0IENv
// SIG // ZGUgU2lnbmluZyBQQ0EwggEiMA0GCSqGSIb3DQEBAQUA
// SIG // A4IBDwAwggEKAoIBAQCycllcGTBkvx2aYCAgQpl2U2w+
// SIG // G9ZvzMvx6mv+lxYQ4N86dIMaty+gMuz/3sJCTiPVcgDb
// SIG // NVcKicquIEn08GisTUuNpb15S3GbRwfa/SXfnXWIz6pz
// SIG // RH/XgdvzvfI2pMlcRdyvrT3gKGiXGqelcnNW8ReU5P01
// SIG // lHKg1nZfHndFg4U4FtBzWwW6Z1KNpbJpL9oZC/6SdCni
// SIG // di9U3RQwWfjSjWL9y8lfRjFQuScT5EAwz3IpECgixzdO
// SIG // PaAyPZDNoTgGhVxOVoIoKgUyt0vXT2Pn0i1i8UU956wI
// SIG // APZGoZ7RW4wmU+h6qkryRs83PDietHdcpReejcsRj1Y8
// SIG // wawJXwPTAgMBAAGjggFeMIIBWjAPBgNVHRMBAf8EBTAD
// SIG // AQH/MB0GA1UdDgQWBBTLEejK0rQWWAHJNy4zFha5TJoK
// SIG // HzALBgNVHQ8EBAMCAYYwEgYJKwYBBAGCNxUBBAUCAwEA
// SIG // ATAjBgkrBgEEAYI3FQIEFgQU/dExTtMmipXhmGA7qDFv
// SIG // pjy82C0wGQYJKwYBBAGCNxQCBAweCgBTAHUAYgBDAEEw
// SIG // HwYDVR0jBBgwFoAUDqyCYEBWJ5flJRP8KuEKU5VZ5KQw
// SIG // UAYDVR0fBEkwRzBFoEOgQYY/aHR0cDovL2NybC5taWNy
// SIG // b3NvZnQuY29tL3BraS9jcmwvcHJvZHVjdHMvbWljcm9z
// SIG // b2Z0cm9vdGNlcnQuY3JsMFQGCCsGAQUFBwEBBEgwRjBE
// SIG // BggrBgEFBQcwAoY4aHR0cDovL3d3dy5taWNyb3NvZnQu
// SIG // Y29tL3BraS9jZXJ0cy9NaWNyb3NvZnRSb290Q2VydC5j
// SIG // cnQwDQYJKoZIhvcNAQEFBQADggIBAFk5Pn8mRq/rb0Cx
// SIG // MrVq6w4vbqhJ9+tfde1MOy3XQ60L/svpLTGjI8x8UJiA
// SIG // IV2sPS9MuqKoVpzjcLu4tPh5tUly9z7qQX/K4QwXacul
// SIG // nCAt+gtQxFbNLeNK0rxw56gNogOlVuC4iktX8pVCnPHz
// SIG // 7+7jhh80PLhWmvBTI4UqpIIck+KUBx3y4k74jKHK6BOl
// SIG // kU7IG9KPcpUqcW2bGvgc8FPWZ8wi/1wdzaKMvSeyeWNW
// SIG // RKJRzfnpo1hW3ZsCRUQvX/TartSCMm78pJUT5Otp56mi
// SIG // LL7IKxAOZY6Z2/Wi+hImCWU4lPF6H0q70eFW6NB4lhhc
// SIG // yTUWX92THUmOLb6tNEQc7hAVGgBd3TVbIc6YxwnuhQ6M
// SIG // T20OE049fClInHLR82zKwexwo1eSV32UjaAbSANa98+j
// SIG // Zwp0pTbtLS8XyOZyNxL0b7E8Z4L5UrKNMxZlHg6K3RDe
// SIG // ZPRvzkbU0xfpecQEtNP7LN8fip6sCvsTJ0Ct5PnhqX9G
// SIG // uwdgR2VgQE6wQuxO7bN2edgKNAltHIAxH+IOVN3lofvl
// SIG // RxCtZJj/UBYufL8FIXrilUEnacOTj5XJjdibIa4NXJzw
// SIG // oq6GaIMMai27dmsAHZat8hZ79haDJLmIz2qoRzEvmtzj
// SIG // cT3XAH5iR9HOiMm4GPoOco3Boz2vAkBq/2mbluIQqBC0
// SIG // N1AI1sM9MIIGBzCCA++gAwIBAgIKYRZoNAAAAAAAHDAN
// SIG // BgkqhkiG9w0BAQUFADBfMRMwEQYKCZImiZPyLGQBGRYD
// SIG // Y29tMRkwFwYKCZImiZPyLGQBGRYJbWljcm9zb2Z0MS0w
// SIG // KwYDVQQDEyRNaWNyb3NvZnQgUm9vdCBDZXJ0aWZpY2F0
// SIG // ZSBBdXRob3JpdHkwHhcNMDcwNDAzMTI1MzA5WhcNMjEw
// SIG // NDAzMTMwMzA5WjB3MQswCQYDVQQGEwJVUzETMBEGA1UE
// SIG // CBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEe
// SIG // MBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMSEw
// SIG // HwYDVQQDExhNaWNyb3NvZnQgVGltZS1TdGFtcCBQQ0Ew
// SIG // ggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCf
// SIG // oWyx39tIkip8ay4Z4b3i48WZUSNQrc7dGE4kD+7Rp9FM
// SIG // rXQwIBHrB9VUlRVJlBtCkq6YXDAm2gBr6Hu97IkHD/cO
// SIG // BJjwicwfyzMkh53y9GccLPx754gd6udOo6HBI1PKjfpF
// SIG // zwnQXq/QsEIEovmmbJNn1yjcRlOwhtDlKEYuJ6yGT1VS
// SIG // DOQDLPtqkJAwbofzWTCd+n7Wl7PoIZd++NIT8wi3U21S
// SIG // tEWQn0gASkdmEScpZqiX5NMGgUqi+YSnEUcUCYKfhO1V
// SIG // eP4Bmh1QCIUAEDBG7bfeI0a7xC1Un68eeEExd8yb3zuD
// SIG // k6FhArUdDbH895uyAc4iS1T/+QXDwiALAgMBAAGjggGr
// SIG // MIIBpzAPBgNVHRMBAf8EBTADAQH/MB0GA1UdDgQWBBQj
// SIG // NPjZUkZwCu1A+3b7syuwwzWzDzALBgNVHQ8EBAMCAYYw
// SIG // EAYJKwYBBAGCNxUBBAMCAQAwgZgGA1UdIwSBkDCBjYAU
// SIG // DqyCYEBWJ5flJRP8KuEKU5VZ5KShY6RhMF8xEzARBgoJ
// SIG // kiaJk/IsZAEZFgNjb20xGTAXBgoJkiaJk/IsZAEZFglt
// SIG // aWNyb3NvZnQxLTArBgNVBAMTJE1pY3Jvc29mdCBSb290
// SIG // IENlcnRpZmljYXRlIEF1dGhvcml0eYIQea0WoUqgpa1M
// SIG // c1j0BxMuZTBQBgNVHR8ESTBHMEWgQ6BBhj9odHRwOi8v
// SIG // Y3JsLm1pY3Jvc29mdC5jb20vcGtpL2NybC9wcm9kdWN0
// SIG // cy9taWNyb3NvZnRyb290Y2VydC5jcmwwVAYIKwYBBQUH
// SIG // AQEESDBGMEQGCCsGAQUFBzAChjhodHRwOi8vd3d3Lm1p
// SIG // Y3Jvc29mdC5jb20vcGtpL2NlcnRzL01pY3Jvc29mdFJv
// SIG // b3RDZXJ0LmNydDATBgNVHSUEDDAKBggrBgEFBQcDCDAN
// SIG // BgkqhkiG9w0BAQUFAAOCAgEAEJeKw1wDRDbd6bStd9vO
// SIG // eVFNAbEudHFbbQwTq86+e4+4LtQSooxtYrhXAstOIBNQ
// SIG // md16QOJXu69YmhzhHQGGrLt48ovQ7DsB7uK+jwoFyI1I
// SIG // 4vBTFd1Pq5Lk541q1YDB5pTyBi+FA+mRKiQicPv2/OR4
// SIG // mS4N9wficLwYTp2OawpylbihOZxnLcVRDupiXD8WmIsg
// SIG // P+IHGjL5zDFKdjE9K3ILyOpwPf+FChPfwgphjvDXuBfr
// SIG // Tot/xTUrXqO/67x9C0J71FNyIe4wyrt4ZVxbARcKFA7S
// SIG // 2hSY9Ty5ZlizLS/n+YWGzFFW6J1wlGysOUzU9nm/qhh6
// SIG // YinvopspNAZ3GmLJPR5tH4LwC8csu89Ds+X57H2146So
// SIG // dDW4TsVxIxImdgs8UoxxWkZDFLyzs7BNZ8ifQv+AeSGA
// SIG // nhUwZuhCEl4ayJ4iIdBD6Svpu/RIzCzU2DKATCYqSCRf
// SIG // WupW76bemZ3KOm+9gSd0BhHudiG/m4LBJ1S2sWo9iaF2
// SIG // YbRuoROmv6pH8BJv/YoybLL+31HIjCPJZr2dHYcSZAI9
// SIG // La9Zj7jkIeW1sMpjtHhUBdRBLlCslLCleKuzoJZ1GtmS
// SIG // hxN1Ii8yqAhuoFuMJb+g74TKIdbrHk/Jmu5J4PcBZW+J
// SIG // C33Iacjmbuqnl84xKf8OxVtc2E0bodj6L54/LlUWa8kT
// SIG // o/0xggSQMIIEjAIBATCBkDB5MQswCQYDVQQGEwJVUzET
// SIG // MBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVk
// SIG // bW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0
// SIG // aW9uMSMwIQYDVQQDExpNaWNyb3NvZnQgQ29kZSBTaWdu
// SIG // aW5nIFBDQQITMwAAALARrwqL0Duf3QABAAAAsDAJBgUr
// SIG // DgMCGgUAoIGyMBkGCSqGSIb3DQEJAzEMBgorBgEEAYI3
// SIG // AgEEMBwGCisGAQQBgjcCAQsxDjAMBgorBgEEAYI3AgEV
// SIG // MCMGCSqGSIb3DQEJBDEWBBRJtIMnkXI0eBKZ9J0u4N/I
// SIG // 3eeZUTBSBgorBgEEAYI3AgEMMUQwQqAogCYAcwBuAGEA
// SIG // cABzAGgAbwB0AEQAYQB0AGEAVgBpAGUAdwAuAGoAc6EW
// SIG // gBRodHRwOi8vbWljcm9zb2Z0LmNvbTANBgkqhkiG9w0B
// SIG // AQEFAASCAQAZ3DEZBrPzsvZw2BwCzzXbEcoZ04cmAChg
// SIG // D9PA91bBM30xgvoFBmXyp51DLcsqjdNZEzWVP9JBFBSg
// SIG // 8G8xiTB90pSd7D2vhINqzOM3JyTYdom9UaYHtwWFSW0X
// SIG // GZ7rWYOxmnXYeUkOcbwdZCot5KoKwRSbcZ0qzc52a4lb
// SIG // bSbzwcC22y+roSKH1sPcQaFH6K9cv+D0ryaxv4ZKX2jP
// SIG // yqzhmO2Zac4KyeUir3BsdLb/xhrRfb3m3qEGKzAtRp4N
// SIG // 68Uxl0KjBDHbbA1h7AVqviY5D43HrmsGrfZzbz7mRXXn
// SIG // ZNRykgjKBVY8+EoUEVr9/MZXxOyj1Nv4BgaEegwCips+
// SIG // oYICHzCCAhsGCSqGSIb3DQEJBjGCAgwwggIIAgEBMIGF
// SIG // MHcxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5n
// SIG // dG9uMRAwDgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVN
// SIG // aWNyb3NvZnQgQ29ycG9yYXRpb24xITAfBgNVBAMTGE1p
// SIG // Y3Jvc29mdCBUaW1lLVN0YW1wIFBDQQIKYQKSSgAAAAAA
// SIG // IDAJBgUrDgMCGgUAoF0wGAYJKoZIhvcNAQkDMQsGCSqG
// SIG // SIb3DQEHATAcBgkqhkiG9w0BCQUxDxcNMTMwMzE1MDYz
// SIG // MzU5WjAjBgkqhkiG9w0BCQQxFgQURRtAszRLQuFrrE6k
// SIG // 6mO58SgpOQIwDQYJKoZIhvcNAQEFBQAEggEAPETsoPjw
// SIG // ZPaWhSqf8vxe5qvsY/viky+YO4Nn4vXtqDlORNeUZI2f
// SIG // 6yZrVZxe0F4WfkPSjwbTRvRx+R7Jl+/QRlIi7CFtdZE0
// SIG // cjUh+wJMxwKckrwt7O1eyAsx+D4rPFbHzbmSs43SG0Aj
// SIG // J2AAyj9923Xu6wLzLrsjbNIAdkxQF3Hq2B3501Tt+o65
// SIG // Oc2TY0wnCY/kv7DDfSWpKZ75hmWjyO5J/2+dTqZdcurB
// SIG // eQSejz8Hmr8VnR0bqCUSMLKAo3VzFR457AfMj0kehOgo
// SIG // dw/GQnXGYT6/UPNRquOZNNBjDa9pJXofpLDesDdTYyVu
// SIG // 9UiBqLYEa+iyRjOuSM6r4yubkg==
// SIG // End signature block
